import java.awt.*;



public class HistoryPanel extends Panel {




  MediaTracker tracker;
  Image myselfImage;

  NorthEastPanel nEP;

  int ty;



  
  public HistoryPanel(MainWindow mainWindow) {


    nEP = mainWindow. northEastPanel;

    setLayout(null);

    // Bilder fuer Homepage holen.
    myselfImage = 
      mainWindow. httpApplet. getImage( mainWindow. httpApplet. getCodeBase(),
					"../images/myself.jpg" ); 

    // Load first the images fully
    tracker = new MediaTracker(this);
    tracker.addImage(myselfImage, 0);

    try {
      tracker.waitForAll();
    } catch (InterruptedException e) {
      return;
    }

  }



  public void paint(Graphics g) {
    update(g);
  }
  
   

  public void update(Graphics g) {

    
    g. clearRect(0, 0, size(). width, size(). height); 
 
    g. setColor(Color.black);

    int x1, x2, y1, y2;

    // Zeichne Zeitachse nach unten fuer Client.
    x1 = size().width/2 + size().width/8 - 5;
    y1 = 0;
    x2 = x1;
    y2 = size().height - 5;
    g. drawLine(x1, y1, x2, y2);

    // Spitzen
    x1 = x1;
    y1 = y2;
    x2 = x1 - 4;
    y2 = y1 - 8;
    g. drawLine(x1, y1, x2, y2);

    x1 = x1;
    y1 = y1;
    x2 = x1 + 4;
    y2 = y1 - 8;
    g. drawLine(x1, y1, x2, y2);


    // Zeichne Zeitachse nach unten fuer Server
    x1 = size().width - size().width/8 + 5;
    y1 = 0;
    x2 = x1;
    y2 = size().height - 5;
    g. drawLine(x1, y1, x2, y2);

    // Spitzen
    x1 = x1;
    y1 = y2;
    x2 = x1 - 4;
    y2 = y1 - 8;
    g. drawLine(x1, y1, x2, y2);

    x1 = x1;
    y1 = y1;
    x2 = x1 + 4;
    y2 = y1 - 8;
    g. drawLine(x1, y1, x2, y2);




    // Falls Fenster vergroessert wurde, oder Scrollbar betaetigt wurde
    // wird die paint() Methode automatisch vom System nochmal aufgerufen
    // so dass in dieser Funktion, was bis zum Zeitpunkt gezeichnet wurde
    // nochmal gezeichnet werden muss.
    if ( nEP. start == true ) {

      drawStringAtClient("Client requests", 10);
      drawStringAtClient("TCP connection", 30);
      drawStringAtClient("for HTML file", 50);
    }
    if ( nEP.firstTCPHandshakeToOpenFirstConnection == true ) {

      drawPointerToRight(0, Color. yellow);
      drawStringRight("SYN", 20);
    }
    
    if ( nEP.secondTCPHandshakeToOpenFirstConnection == true ) {
      
      drawPointerToLeft(50, Color. yellow);
      drawStringLeft("SYN + ACK", 70);
    }
    
    if ( nEP.thirdTCPHandshakeToOpenFirstConnection == true ) {
      
      drawPointerToRight(100, Color. yellow);
      drawStringRight("ACK", 120);
      drawStringCenter("TCP Connection Opened", 175);
    }
    
    if ( nEP.firstRequestReached == true  ) {
      
      drawPointerToRight(200, Color. green);
      drawStringRight("HTTP Request", 220);
      drawStringAtClient("Client sends", 210 );
      drawStringAtClient("HTTP request", 230);
      drawStringAtClient("for HTML file", 250);

      drawStringAtServer("Server", 260);
      drawStringAtServer("reads", 280);
      drawStringAtServer("from", 300);
      drawStringAtServer("disk", 320);
      drawPointerAtServer(250);
    }
    
    if ( nEP.firstResponseReached == true ) {
      
      drawPointerToLeft(300, Color. green);
      drawHomepageImage_1(350);
      drawStringLeft("HTTP Response", 320);
      drawStringCenter("End of Data Transfer", 375);

      drawPointerAtClient(340);
      drawStringAtClient("Client parses", 360);
      drawStringAtClient("HTML file", 380);
    }
    
    if ( nEP.firstTCPHandshakeToCloseFirstConnection == true ) {
      
      drawPointerToLeft(400, Color. yellow);
      drawStringLeft("FIN", 420);
      drawStringAtServer("Server", 410);
      drawStringAtServer("closes", 430);
      drawStringAtServer("TCP-", 450);
      drawStringAtServer("connection", 470);
    }

    if ( nEP.secondTCPHandshakeToCloseFirstConnection == true ) {

      drawPointerToRight(450, Color. yellow);
      drawStringRight("FIN + ACK", 470);
    }

    if ( nEP.thirdTCPHandshakeToCloseFirstConnection == true ) {
      
      drawPointerToLeft(500, Color. yellow);
      drawStringLeft("ACK", 520);
      drawStringCenter("TCP Connection Closed", 575);
    }

    if ( nEP.firstTCPHandshakeToOpenSecondConnection == true ) {
      
      drawPointerToRight(600, Color. yellow);
      drawStringRight("SYN", 620);
      drawStringAtClient("Client requests", 610);
      drawStringAtClient("TCP connection", 630);
      drawStringAtClient("for image", 650);
    }
    
    if ( nEP.secondTCPHandshakeToOpenSecondConnection == true ) {
      
      drawPointerToLeft(650, Color. yellow);
      drawStringLeft("SYN + ACK", 670);
    }
    
    if ( nEP.thirdTCPHandshakeToOpenSecondConnection == true ) {
      
      drawPointerToRight(700, Color. yellow);
      drawStringRight("ACK", 720);
      drawStringCenter("TCP Connection Opened", 775);
    }
    
    if ( nEP.secondRequestReached == true  ) {
      
      drawPointerToRight(800, Color. green);
      drawStringRight("HTTP Request", 820);
      drawStringAtClient("Client sends", 810);
      drawStringAtClient("HTTP request", 830);
      drawStringAtClient("for image", 850);

      drawStringAtServer("Server", 860);
      drawStringAtServer("reads", 880);
      drawStringAtServer("from", 900);
      drawStringAtServer("disk", 920);
      drawPointerAtServer(850);
    }
    
    if ( nEP.secondResponseReached == true ) {
      
      drawPointerToLeft(900, Color. green);
      drawHomepageImage_2(950);
      drawStringLeft("HTTP Response", 920);
      drawStringCenter("End of Data Transfer", 975);

      drawPointerAtClient(980);
      drawStringAtClient("Client", 1015);
      drawStringAtClient("browses image", 1030);
    }
    
    if ( nEP.firstTCPHandshakeToCloseSecondConnection == true ) {
      
      drawPointerToLeft(1000, Color. yellow);
      drawStringLeft("FIN", 1020);
      drawStringAtServer("Server", 1010);
      drawStringAtServer("closes", 1030);
      drawStringAtServer("TCP-", 1050);
      drawStringAtServer("connection", 1070);
    }
    
    if ( nEP.secondTCPHandshakeToCloseSecondConnection == true ) {
      
      drawPointerToRight(1050, Color. yellow);
      drawStringRight("FIN + ACK", 1070);
    }
    
    if ( nEP.thirdTCPHandshakeToCloseSecondConnection == true ) {
      
      drawPointerToLeft(1100, Color. yellow);
      drawStringLeft("ACK", 1120);
      drawStringCenter("TCP Connection Closed", 1175);
    }
    

  }





  public void drawHomepageImage_1(int y) {



    Graphics g = getGraphics();

    g. translate(0, - ty);

    int homepageWidth = 250;
    int homepageHeight = 300;
    int homepageXPosition = size(). width/4 - homepageWidth/2 - 10;
    int homepageYPosition = y;

    int stringXPosition = homepageXPosition + homepageWidth/20;


    g. setColor(Color.black);
    g. drawRect( homepageXPosition, homepageYPosition,
		 homepageWidth, homepageHeight );

    g. setColor(Color. white);
    g. fillRect(  homepageXPosition,  homepageYPosition,
		  homepageWidth, homepageHeight );


    g. setColor(Color.black);
    g. setFont(new Font("Helvetica", Font. PLAIN, 18));
    g. drawString("This is my homepage",
		  stringXPosition, homepageYPosition + 30 );

    g. setFont(new Font("Helvetica", Font. BOLD, 18));
    g. drawString("Ain't it nice ?", stringXPosition, homepageYPosition + 60);

    g. setFont(new Font("Helvetica", Font. PLAIN, 18));
    g. drawString("Here's a picture of me:",
		  stringXPosition, homepageYPosition + 90);
 

  }




  public void drawHomepageImage_2(int y) {


    
    Graphics g = getGraphics();

    g. translate(0, - ty);

    int homepageWidth = 250;
    int homepageHeight = 350;
    int homepageXPosition = size(). width/4 - homepageWidth/2 - 10;
    int homepageYPosition = y;

    g. setColor(Color.black);
    g. drawRect(  homepageXPosition, homepageYPosition,
		  homepageWidth, homepageHeight );

    g. setColor(Color. white);
    g. fillRect(  homepageXPosition, homepageYPosition,
		  homepageWidth, homepageHeight );


    int stringXPosition = homepageXPosition + homepageWidth/20;

    g. setColor(Color.black);
    g. setFont(new Font("Helvetica", Font. PLAIN, 18));
    g. drawString("This is my homepage",
		  stringXPosition, homepageYPosition + 30);

    g. setFont(new Font("Helvetica", Font. BOLD, 18));
    g. drawString("Ain't it nice ?",
		  stringXPosition, homepageYPosition + 60);

    g. setFont(new Font("Helvetica", Font. PLAIN, 18));
    g. drawString("Here's a picture of me:",
		  stringXPosition, homepageYPosition + 90);


    g. drawImage(myselfImage,
		 homepageXPosition + 80, homepageYPosition + 100,
		 80, 140, this);
    g. drawRect(homepageXPosition + 79, homepageYPosition + 99,
		82, 142);

    g. drawString("If you Want to see a picture",
		  stringXPosition, homepageYPosition + 100 + 142 + 30);
    g. drawString("of my wife, click",
		  stringXPosition, homepageYPosition + 100 + 142 + 60);

    g. setColor(Color.blue);
    FontMetrics fontMetrics = g. getFontMetrics();
    g. drawString("here",
		  stringXPosition + 
		  fontMetrics.stringWidth("of my wife, click") + 5,
		  homepageYPosition + 100 + 142 + 60);
    g. drawLine( stringXPosition + 
		 fontMetrics.stringWidth("of my wife, click") + 5, 
		 homepageYPosition + 100 + 142 + 60 + 2,
		 stringXPosition + 
		 fontMetrics.stringWidth("of my wife, click") + 5 +
		 fontMetrics.stringWidth("here"),
		 homepageYPosition + 100 + 142 + 60 + 2);


  }




  public void drawPointerToRight(int offset, Color color) {


    Graphics g = getGraphics();

    g. translate(0, - ty);


    int[] x = new int[7];
    int[] y = new int[7];


    x[0] = size(). width/2 + size().width/8 + 5;
    x[1] = size(). width - size().width/8 - 20;
    x[2] = x[1] - 8;
    x[3] = x[2] + 25 ;
    x[4] = x[3] - 27;
    x[5] = x[1] - 1;
    x[6] = x[0] - 1;
    
    y[0] = 5 + offset;
    y[1] = y[0] + 30;
    y[2] = y[1] - 7;
    y[3] = y[2] + 12 ;
    y[4] = y[3] + 4;
    y[5] = y[1] + 5;
    y[6] = y[0] + 5;
    
    Polygon pointer = new Polygon(x, y, 7);
    
    g. setColor(color);
    g. fillPolygon(pointer);

    g. setColor(Color. black);
    g. drawPolygon(pointer);
        
  }




  public void drawPointerToLeft(int offset, Color color) {


    Graphics g = getGraphics();

    g. translate(0, - ty);


    int[] x = new int[7];
    int[] y = new int[7];


    x[0] = size(). width - size().width/8 - 5;
    x[1] = size(). width/2 + size().width/8 + 20;
    x[2] = x[1] + 8;
    x[3] = x[2] - 25 ;
    x[4] = x[3] + 27;
    x[5] = x[1] + 1;
    x[6] = x[0] + 1;
    
    y[0] = 5 + offset;
    y[1] = y[0] + 30;
    y[2] = y[1] - 7;
    y[3] = y[2] + 12;
    y[4] = y[3] + 4;
    y[5] = y[1] + 5;
    y[6] = y[0] + 5;
    

    Polygon pointer = new Polygon(x, y, 7);
    

    g. setColor(color);
    g. fillPolygon(pointer);
    
    g. setColor(Color. black);
    g. drawPolygon(pointer);
        
  }



  public void drawStringRight(String string, int y) {


    Graphics g = getGraphics();

    int x = size().width * 3/4 + size().width/16 - 5;
    
    g. translate(0, - ty);

    g. setFont(new Font("Helvetica", Font. PLAIN, 12));
    FontMetrics fontMetrics = g. getFontMetrics();

    g. setColor(getBackground());
    g. fillRect( x - 2,
		 y - fontMetrics. getAscent() - 2,
		 fontMetrics. stringWidth(string) + 4,
		 fontMetrics. getHeight() + 4 );

    g. setColor(Color. black);
    g. drawString(string, x, y);
  }




  public void drawStringLeft(String string, int y) {

    
    Graphics g = getGraphics();

    int x = size().width/2 + size().width/8 + 5;

    g. translate(0, - ty);


    g. setFont(new Font("Helvetica", Font. PLAIN, 12));
    FontMetrics fontMetrics = g. getFontMetrics();

    g. setColor(getBackground());
    g. fillRect( x - 2,
		 y - fontMetrics. getAscent() - 2,
		 fontMetrics. stringWidth(string) + 4,
		 fontMetrics. getHeight() + 4 );

    g. setColor(Color. black);
    g. drawString(string, x, y);

  }




  public void drawStringCenter(String string, int y) {


    Graphics g = getGraphics();


    g. translate(0, - ty);

    g. setFont(new Font("Helvetica", Font. PLAIN, 12));

    FontMetrics fontMetrics = g. getFontMetrics();

    int x0 = size().width * 3/4 - fontMetrics. stringWidth(string)/2;


    g. setColor(Color. black);

    g. drawString(string, x0, y + fontMetrics. getAscent()/2);

    int x1 = size().width/2 + size().width/8 + 5; 
    int x2 = size().width * 3/4 - fontMetrics. stringWidth(string)/2 - 5; 
    int x3 = size().width * 3/4 + fontMetrics. stringWidth(string)/2 + 5; 
    int x4 = size().width - size().width/8 - 5; 
    
    g. drawLine(x1, y, x2, y);
    g. drawLine(x3, y, x4, y);

  }




  public void drawStringAtClient(String string, int y) {


    Graphics g = getGraphics();

    int x = size(). width/2 + size(). width/8 - 100;

    g. translate(0, - ty);

    g. setFont(new Font("Helvetica", Font. PLAIN, 12));
    FontMetrics fontMetrics = g. getFontMetrics();

    g. setColor(getBackground());
    g. fillRect( x - 2,
		 y - fontMetrics. getAscent() - 2,
		 fontMetrics. stringWidth(string) + 4,
		 fontMetrics. getHeight() + 4 );

    g. setColor(Color. black);
    g. drawString(string, x, y);

  }



  public void drawStringAtServer(String string, int y) {


    Graphics g = getGraphics();

    int x = size().width - size().width/8 + 30;

    g. translate(0, - ty);

    g. setFont(new Font("Helvetica", Font. PLAIN, 12));
    FontMetrics fontMetrics = g. getFontMetrics();

    g. setColor(getBackground());
    g. fillRect( x - 2,
		 y - fontMetrics. getAscent() - 2,
		 fontMetrics. stringWidth(string) + 4,
		 fontMetrics. getHeight() + 4 );

    g. setColor(Color. black);
    g. drawString(string, x, y);

  }



  public void drawPointerAtClient( int y0 ) {


    Graphics g = getGraphics();

    int x0 = size().width/2 + size().width/8 - 20;

    g. translate(0, - ty);

    g. setColor(Color. black);
    g. drawLine(x0, y0, x0, y0 + 250);
    
    int[] x = new int[3];
    int[] y = new int[3];
    
    x[0] = x0 + 3;
    x[1] = x0 - 3 ;
    x[2] = x0;
    
    y[0] = y0 + 235;
    y[1] = y0 + 235;
    y[2] = y0 + 250;
    
    Polygon pointerTriangle = new Polygon(x, y, 3);
    
    g. fillPolygon(pointerTriangle);


  }



  public void drawPointerAtServer( int y0 ) {


    Graphics g = getGraphics();

    int x0 = size().width - size().width/8 + 20;

    g. translate(0, - ty);

    g. setColor(Color. black);
    g. drawLine(x0, y0, x0, y0 + 50);

    int[] x = new int[3];
    int[] y = new int[3];
    
    x[0] = x0 - 2;
    x[1] = x0 + 2;
    x[2] = x0;
    
    y[0] = y0 + 40;
    y[1] = y0 + 40;
    y[2] = y0 + 50;
    
    Polygon pointerTriangle = new Polygon(x, y, 3);
    
    g. fillPolygon(pointerTriangle);
    

  }










}





